/*------------------------------------------------------------------------------*
 * File Name:WksInfoSplitter.c 													*
 * Creation:																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	Frank 3/20/05 v8.0207 APPLY_ADDTREENODES_WITH_NEW_RULE						*
 *------------------------------------------------------------------------------*/
#include <Origin.h>

#define _DMSG(_str) //out_str(_str);
#define	_DMN(_str,_nn) //out_int(_str, _nn)

/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include "TreeEditSplitter.h"
///	#include "HelpID.h"	/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H


class WksInfoCategory : public GridTreeControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridTreeControl::Init(nID, dlg);
		//m_flx.FocusRect = flexFocusHeavy;
		//m_flx.HighLight = flexHighlightWithFocus;
		//m_flx.SelectionMode = flexSelectionListBox;
		////////////////////////////////////////////
		//tree_get_project_folders_and_pages(m_PEFolders);
		m_wksInfo.Import.File.strVal = "test";
		m_wksInfo.Link.Operations.O1.strVal = "some test";
		
		///DG 4/18/05 REWRITE_TREE_GET_NODE
		/*
		///Frank 3/20/05 v8.0207 APPLY_ADDTREENODES_WITH_NEW_RULE					
		//AddTreeNodes(m_wksInfo, ATRN_SKIP_LEAFS); // show only folders
		AddTreeNodes(m_wksInfo, -1, NULL, true, true ); // show only folders
		///End APPLY_ADDTREENODES_WITH_NEW_RULE					
		*/
		AddTreeNodes(m_wksInfo, ATRN_SKIP_LEAFS);
		///end REWRITE_TREE_GET_NODE
	}
private:
	TreeNode get_tree_node(int nRow)
	{
		int nIndex = nRow - m_flx.FixedRows;
		//return tree_get_node(m_wksInfo, nIndex, 1); // TD 3-31-04		///DG 4/20/05 REWRITE_TREE_GET_NODE
		return tree_get_node(m_wksInfo, nIndex, ATRN_STOP_LEVEL | 1);
	}

private:
	Tree	m_wksInfo;
};

class WksInfoSplitter : public TreeEditSplitter
{
public:
	WksInfoSplitter() : TreeEditSplitter(true, true)
	{
	}
	BOOL CreateWindow(int nID, HWND hWndParent)
	{
		Window wndParent(hWndParent);
		Init(nID, wndParent,0, "WksInfo");
		return TRUE;
	}

protected:
EVENTS_BEGIN
	ON_INIT(OnInit)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)

	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	
EVENTS_END
	BOOL OnInit()
	{
		CreateTreeEditPane();
		GUID clsid; // later, for now, only vsFlex
		CreateMainActiveXPane(clsid);
		m_infoTree.Init(GetMainPaneID(), *this);
		
		return SetReady();
	}
	//virtual
	void ConstructTree()
	{
		GETN_TREE(trTemp)
		GETN_STR(junk, "Tesing", "This is a test")
		m_paramTree = trTemp;
	}
private:
	WksInfoCategory		m_infoTree;
};


/// the following are only for testing
#include "ResizeDialog.h"
#include "Odlg8.h"
#include "MultiPaneDlg.h"

#define STR_DLG_NAME "WksTreeEditDlg"

class WksTreeEditDlg : public MultiPaneDlg
{
public:
	WksTreeEditDlg() : MultiPaneDlg(IDD_PRESENTATION_MANAGER, "ODlg8") // use Presentation Manager resource,
	{
	}	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		return DoModal(hWndParent);
	}
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_BN_CLICKED(IDC_PM_SHOW_PE, OnShowBottomPane)
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		waitCursor junk;
		//Profiler jj;
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Bottom Pane");
		vstrTipsUpDown[1] = _L("Hide Bottom Pane");
		MultiPaneDlg::OnInitDialog(IDC_PM_PRESENTATIONS, IDC_PM_SHOW_PE, vstrTipsUpDown, STR_DLG_NAME);
		
		m_Top.Init(IDC_PM_PRESENTATIONS, *this, 0, STR_DLG_NAME);
		m_Bottom.Init(IDC_PM_PE_PAGES, *this, 1, STR_DLG_NAME);
		m_Top.Visible = true;
		SetInitReady();
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
			
		uint nButtonIDs[] = {IDOK, IDC_PM_NEW, IDC_PM_ADD, IDC_PM_REMOVE, 0};
		MultiPaneDlg::OnDlgResize(IDC_PM_PRESENTATIONS, IDC_PM_PE_PAGES, nButtonIDs, cx, cy);
		return TRUE;
	}
	
	//////////// local utilities/helper functions
private:
	ListTreeEditSplitter	m_Top;
	WksInfoSplitter			m_Bottom;

};

bool WTest()
{
	WksTreeEditDlg myDlg;
	
	int nRet = myDlg.DoModalEx(GetWindow());
	return true;
}

	